/*
 * @(#)ZipMenuBar.java	1.0 98/12/11
 *
 * Java Project performed by
 *     Frank Moisant
 *    Patrick Titiano
 *        (ITRA3)
 *
 */


import com.sun.java.swing.JMenuBar;


/**
 * Class to make the menu bar in the main frame
 * @see ZipMenuFichier
 * @see ZipMenuAction
 * @see ZipMenuStyle
 * @see ZipMenuEdit
 * @see AllActionListener
 * @version 1.0
 * @author Frank Moisant - Patrick Titiano
 */
public class ZipMenuBar extends JMenuBar {

    // private members
    private ZipMenuFichier menuFichier;
    private ZipMenuAction menuAction;
    private ZipMenuEdit menuEdit;
    private ZipMenuStyle menuStyle;

    /**
     * Constructor of the class
     * @param allActionListener the global action listener
     */
    public ZipMenuBar(AllActionListener allActionListener) {
	super();
	menuFichier = new ZipMenuFichier(allActionListener);
	menuAction = new ZipMenuAction(allActionListener);
	menuEdit = new ZipMenuEdit(allActionListener);
	menuStyle = new ZipMenuStyle(allActionListener);

	add(menuFichier);
	add(menuAction);
	add(menuEdit);
	add(menuStyle);
	enabledActionMenu(false);
    }


    /**
     * Method to enable the action and edit menu
     * @param flag true to enable them
     */
    public void enabledActionMenu(boolean flag) {
	menuAction.setEnabled(flag);
	menuEdit.setEnabled(flag);
    }
}

